/*------------------------------------------
   PLGBLT.C -- Win32 Rotated Bitmap Display
               (c) Charles Petzold, 1992
  ------------------------------------------*/

#define OEMRESOURCE
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>

LONG APIENTRY WndProc (HWND, UINT, DWORD, LONG) ;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {
     static char szAppName[] = "PlgBlt" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ;

     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;

     RegisterClass (&wndclass) ;

     hwnd = CreateWindow (szAppName, "Rotated Bitmap Display",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }

HBITMAP LoadChessBitmap (HDC hdc)
     {
     BITMAPFILEHEADER bf ;
     BYTE *           pBuffer ;
     FILE *           file ;
     HBITMAP          hbm ;

     if (NULL == (file = fopen ("\\nt\\windows\\chess.bmp", "rb")))
          return NULL ;

     if (1 != fread (&bf, sizeof (BITMAPFILEHEADER), 1, file))
          {
          fclose (file) ;
          return NULL ;
          }

     if (NULL == (pBuffer = malloc (bf.bfSize)))
          {
          fclose (file) ;
          return NULL ;
          }

     fread (pBuffer, bf.bfSize, 1, file) ;
     fclose (file) ;

     hbm = CreateDIBitmap (hdc, (PBITMAPINFOHEADER) pBuffer, CBM_INIT,
                           pBuffer + bf.bfOffBits - sizeof (BITMAPFILEHEADER),
                           (PBITMAPINFO) pBuffer, DIB_RGB_COLORS) ;
     free (pBuffer) ;

     return hbm ;
     }

LONG APIENTRY WndProc (HWND hwnd, UINT message, DWORD wParam, LONG lParam)
     {
     static HBITMAP hbmChess ;
     static short   cxClient, cyClient ;
     HDC            hdc, hdcMem ;
     PAINTSTRUCT    ps ;
     POINT          apt [3] ;

     switch (message)
          {
          case WM_CREATE:
               hdc = GetDC (hwnd) ;

               hbmChess = LoadChessBitmap (hdc) ;

               ReleaseDC (hwnd, hdc) ;
               return 0 ;

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_PAINT:
	       hdc = BeginPaint (hwnd, &ps) ;

               if (hbmChess)
                    {
                    hdcMem = CreateCompatibleDC (hdc) ;
                    SelectObject (hdcMem, hbmChess) ;

                    apt[0].x = 0 ;
                    apt[0].y = cyClient / 2 ;

                    apt[1].x = cxClient / 2 ;
                    apt[1].y = 0 ;

                    apt[2].x = cxClient / 2 ;
                    apt[2].y = cyClient ;

                    PlgBlt (hdc, apt, hdcMem, 0, 0, 640, 480, NULL, 0, 0) ;

                    DeleteDC (hdcMem) ;
                    }

	       EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               if (hbmChess)
                    DeleteObject (hbmChess) ;

               PostQuitMessage (0) ;
               return 0 ;
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }
